%% Sample Model Validation
%
%% Load sample data from MAT files
% Response with nominal model.
load('data_mdl_val_nom.mat');
t_n = wl(:,1);
wl_n_m = wl(:,2);
wl_n_s = wl(:,3);
% Response with bumptest model.
load('data_mdl_val_bumptest.mat');
t_b = wl(:,1);
wl_b_m = wl(:,2);
wl_b_s = wl(:,3);
% Response with bumptest model.
load('data_mdl_val_freqrsp.mat');
t_f = wl(:,1);
wl_f_m = wl(:,2);
wl_f_s = wl(:,3);
%
%% Plot response
% Plot axis ranges
t_min = 3.5;
t_max = 4.5;
y_min = 0;
y_max = 5;
% Nominal plot
subplot(3,1,1)
plot(t_n,wl_n_m,'r-',t_n,wl_n_s,'b:');
ylabel('\omega_l (rad/s)')
title('\bf Nominal');
axis([t_min t_max y_min y_max]);
% Frequency response plot
subplot(3,1,2)
plot(t_f,wl_f_m,'r-',t_f,wl_f_s,'b:');
ylabel('\omega_l (rad/s)')
axis([t_min t_max y_min y_max]);
title('\bf Frequency Response')
% Bumptest plot
subplot(3,1,3)
plot(t_b,wl_b_m,'r-',t_b,wl_b_s,'b:');
ylabel('\omega_l (rad/s)')
axis([t_min t_max y_min y_max]);
title('\bf Bumptest');
xlabel('time (s)');